<?php if (!defined('__TYPECHO_ROOT_DIR__')) exit; ?>
<!DOCTYPE html>
<html lang="cn">
<head>
<meta charset="<?php $this->options->charset(); ?>" />
<meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
<meta name="google" content="notranslate" />
<title><?php $this->archiveTitle(array(
            'category'  =>  _t('分类 %s 下的文章'),
            'search'    =>  _t('包含关键字 %s 的文章'),
            'tag'       =>  _t('标签 %s 下的文章'),
            'author'    =>  _t('%s 发布的文章')
        ), '', ' - '); ?><?php $this->options->title(); ?></title>
<link rel="stylesheet" href="<?php $this->options->themeUrl('style.css'); ?>">
<?php $this->header(); ?>
<script>
    // 主题切换功能
    document.addEventListener('DOMContentLoaded', function() {
        const themeToggle = document.getElementById('themeToggle');
        const body = document.body;
        
        // 设置初始按钮图标
        if (body.classList.contains('dark')) {
            themeToggle.textContent = '☀️';
        } else {
            themeToggle.textContent = '🌙';
        }
        
        // 添加点击事件监听器
        themeToggle.addEventListener('click', function() {
            // 切换主题类
            body.classList.toggle('dark');
            
            // 更新按钮图标
            if (body.classList.contains('dark')) {
                themeToggle.textContent = '☀️';
                localStorage.setItem('theme', 'dark');
            } else {
                themeToggle.textContent = '🌙';
                localStorage.setItem('theme', 'light');
            }
        });
        
        // 监听系统主题变化
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', function(e) {
            if (!localStorage.getItem('theme')) {
                if (e.matches) {
                    body.classList.add('dark');
                    themeToggle.textContent = '☀️';
                } else {
                    body.classList.remove('dark');
                    themeToggle.textContent = '🌙';
                }
            }
        });
        
        // 搜索功能
        const searchToggle = document.getElementById('searchToggle');
        const searchContainer = document.querySelector('.search-container');
        
        if (searchToggle && searchContainer) {
            searchToggle.addEventListener('click', function() {
                searchContainer.classList.toggle('active');
                searchToggle.classList.toggle('active');
                
                // 如果搜索容器显示，自动聚焦到搜索输入框
                if (searchContainer.classList.contains('active')) {
                    const searchInput = searchContainer.querySelector('.search-input');
                    if (searchInput) {
                        setTimeout(() => {
                            searchInput.focus();
                        }, 100);
                    }
                }
            });
        }
    });
</script>
</head>

<body>
    <script>
        // 立即设置主题，防止页面闪烁
        (function() {
            const body = document.body;
            
            // 检查本地存储中的主题偏好
            const savedTheme = localStorage.getItem('theme');
            if (savedTheme === 'dark' || (!savedTheme && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                body.classList.add('dark');
            }
        })();
    </script>
    <button class="theme-toggle" id="themeToggle" aria-label="切换主题">🌙</button>
    <button class="search-toggle" id="searchToggle" aria-label="显示搜索">🔍</button>
    <form id="search" method="post" action="<?php $this->options->siteUrl(); ?>" role="search" class="search-form search-container">
        <div class="search-wrapper">
            <input type="text" id="s" name="s" class="search-input" placeholder="搜索..." />
            <button type="submit" class="search-btn">🔍</button>
        </div>
    </form>