<?php if (!defined('__TYPECHO_ROOT_DIR__')) exit; ?>
<?php $this->need('header.php'); ?>
<section id="post">
    <div class="head">
        <div class="avatar">
            <a href="<?php $this->options->siteUrl(); ?>"><img src="<?php $this->options->avatarURL() ?>"></a>
        </div>
        <div class="title">404</div>
    </div>
    <div class="content yue" style="width: 100%; height: 500px; display: flex; flex-direction: column; justify-content: center; align-items: center; gap: 30px;">
        <div style="font-size: 24px; text-align: center;">
            <?php _e('糟糕~你查看的页面失踪了!'); ?>
        </div>
        <div style="width: auto; height: auto; border-radius: 8px; overflow: hidden;">
            <div style="font-size: 20px; text-align: center;">
                看小姐姐吧！
                <a href="javascript:void(0);" id="refresh-video">换一个</a>
            </div><br>
            <video 
                id="404-video" 
                style="width: 100%; height: 100%; border-radius: 8px; object-fit: cover;"
                playsinline 
                webkit-playsinline 
                x5-playsinline 
                preload="auto"
                muted
                loop>
                <source src="https://api.yujn.cn/api/zzxjj.php" type="video/mp4">
                你的浏览器不支持HTML5视频播放
            </video>
        </div>
    </div>
</section>

<script>
(function() {
    const video = document.getElementById('404-video');
    const refreshBtn = document.getElementById('refresh-video');
    const baseUrl = 'https://api.yujn.cn/api/zzxjj.php';
    let userInteracted = false;
    
    // 刷新视频函数
    function refreshVideo() {
        video.pause();
        video.querySelector('source').src = baseUrl + '?t=' + Date.now();
        video.load();
        
        // 重新加载后保持之前的声音状态
        if (userInteracted) {
            video.muted = false;
        }
        
        video.play().catch(() => {
            video.muted = true;
            video.play().catch(console.error);
        });
    }
    
    // 按钮点击事件
    refreshBtn.addEventListener('click', refreshVideo);
    
    // 用户交互处理声音
    document.addEventListener('click', () => {
        if (!userInteracted) {
            userInteracted = true;
            video.muted = false;
            video.play().catch(e => {
                // 如果取消静音失败，保持静音状态
                video.muted = true;
                console.log('自动播放被阻止，保持静音状态');
            });
        }
    }, { once: true });
    
    // 初始静音自动播放
    video.play().catch(() => {
        video.muted = true;
        video.play().catch(console.error);
    });
    
    // 可见性控制
    const observer = new IntersectionObserver(entries => {
        entries.forEach(entry => {
            entry.isIntersecting ? video.play() : video.pause();
        });
    }, { threshold: 0.5 });
    
    observer.observe(video);
})();
</script>

<?php $this->need('footer.php'); ?>